<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Take Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        h1 {
            text-align: center;
        }
        .question-container {
            margin: 20px auto;
            max-width: 600px;
        }
        .question {
            border: 1px solid #ccc;
            padding: 10px;
            margin-bottom: 20px;
        }
        .question p {
            margin: 0;
            font-weight: bold;
        }
        .answers {
            margin-top: 10px;
        }
        .answer {
            margin-bottom: 5px;
        }
        button[type="submit"] {
            display: block;
            margin: 20px auto;
            padding: 10px 20px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>
<link rel="stylesheet" href="../style.css">
    <h1>Pildīt testu</h1>
    <?php
    session_start();
    // Pārbauda, vai test_id parametrs ir iestatīts
    if(isset($_GET['test_id'])) {
        // Pieņemot, ka ir izveidots savienojums ar datu bāzi
        $servername = "localhost";
        $username = "root";
        $password = "";
        $dbname = "quiz_db";

        // Izveido savienojumu
        $conn = new mysqli($servername, $username, $password, $dbname);

        // Pārbauda savienojumu
        if ($conn->connect_error) {
            die("Savienojums neizdevās: " . $conn->connect_error);
        }

        // Iegūst testa ID no URL parametra
        $test_id = $_GET['test_id'];

        // Iegūst testa datus no datu bāzes
        $sql = "SELECT * FROM tests WHERE id = $test_id";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo "<div class='question-container'>";
            echo "<h2>{$row['name']}</h2>";
            echo "<p>{$row['description']}</p>";

            // Iegūst jautājumus izvēlētajam testam
            $sql_questions = "SELECT * FROM questions WHERE test_id = $test_id";
            $result_questions = $conn->query($sql_questions);

            if ($result_questions->num_rows > 0) {
                // Izvada katru jautājumu kopā ar atbilžu opcijām
                echo "<form action='../php/submit_test.php' method='post'>";
                echo "<input type='hidden' name='test_id' value='$test_id'>";
                // Iegūst user_id no sesijas
                $user_id = isset($_SESSION['id']) ? $_SESSION['id'] : null; // Pieņem, ka 'id' ir sesijas mainīgais, kur glabājas lietotāja ID
                echo "<input type='hidden' name='user_id' value='$user_id'>";
                
                while($question_row = $result_questions->fetch_assoc()) {
                    echo "<div class='question'>";
                    echo "<p>{$question_row['question']}</p>";

                    // Iegūst atbilžu opcijas pašreizējam jautājumam
                    $question_id = $question_row['id'];
                    $sql_answers = "SELECT * FROM answers WHERE question_id = $question_id";
                    $result_answers = $conn->query($sql_answers);

                    if ($result_answers->num_rows > 0) {
                        while($answer_row = $result_answers->fetch_assoc()) {
                            echo "<div class='answers'>";
                            echo "<input type='radio' name='answers[{$question_row['id']}]' value='{$answer_row['id']}'> {$answer_row['answer']}<br>";
                            echo "</div>";
                        }
                    } else {
                        echo "Šim jautājumam nav atrastas atbilžu opcijas.";
                    }

                    echo "</div>";
                }
                echo "<button type='submit'>Iesniegt testu</button>";
                echo "</form>";
            } else {
                echo "Šim testam nav atrasti jautājumi.";
            }
            echo "</div>"; // aizver question-container div
        } else {
            echo "Tests nav atrasts.";
        }

        // Aizver savienojumu
        $conn->close();
    } else {
        echo "Testa ID parametrs nav norādīts.";
    }
    ?>
</body>
</html>
